Common and Differential C vs. frequency and DC offset
**********************************************************************
.AC  DEC  10  1.0  10.0e+9  $  SWEEP  Bias  LIN  3  0  5
*---------------------------------------------------------------------
.OPTIONS POST=1 POST_VERSION=9007 CO=132 INGOLD NUMDGT=6 UNWRAP PROBE 
**********************************************************************
.param Vcc = 5.0
.param Vin = 0.0
.param Ven = 0.0
.param Bias= 'Vcc/2'
*---------------------------------------------------------------------
.param Ampl= 1.0e-3
.param Ampl_p= Ampl
.param Ampl_n= 0
.param pi = 3.1415926535897932384626433832795
**********************************************************************
.probe AC
+ Cp    = PAR('sgn(Ampl_p) * (abs(Ii(Vac_p))-abs(Ii(Vac_n)))/(2*pi*HERTZ*Ampl)')
+ Cn    = PAR('sgn(Ampl_n) * (abs(Ii(Vac_n))-abs(Ii(Vac_p)))/(2*pi*HERTZ*Ampl)')
+ Cdiff = PAR('(sgn(Ampl_p)*abs(Ii(Vac_n)) + sgn(Ampl_n)*abs(Ii(Vac_p)))/(2*pi*HERTZ*Ampl)')
**********************************************************************
Vac_p  Out_p  0  AC= Ampl_p  DC= Bias
Vac_n  Out_n  0  AC= Ampl_n  DC= Bias
*
Vvcc   Vvcc   0  DC= Vcc
Vgnd   GRND   0  DC= 0
*
Vin    In     0  DC= Vin
Ven    En     0  DC= Ven
**********************************************************************
* Dummy circuit representing a buffer for testing the measurement
**********************************************************************
Rpu_p  Out_p  Vcc    R= 10.0
Rpd_p  Out_p  GRND   R= 1000
Rpu_n  Out_n  Vcc    R= 1000
Rpd_n  Out_n  GRND   R= 10.0
Rdiff  Out_p  Out_n  R= 50.0

Cpd_p  Out_p  GRND   C= 4.0pF
Cpd_n  Out_n  GRND   C= 3.0pF
Cdiff  Out_p  Out_n  C= 2.0pF
*---------------------------------------------------------------------
* Place actual buffer call here and comment out above section
*---------------------------------------------------------------------
*X1  In  Out_p  Out_n  Vcc  GRND  En  IO_diff
**********************************************************************
.alter                       $ This will repeat the measurment on the
.param Ampl_p= 0             $ other output
.param Ampl_n= Ampl
**********************************************************************
.END
**********************************************************************
